<?php
require 'config.php';

// Check if user is logged in
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$is_admin = isset($_SESSION['is_admin']) ? $_SESSION['is_admin'] : false;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projects - SourceHub</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }
        
        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        nav {
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            gap: 20px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .nav-links a, .nav-links button {
            text-decoration: none;
            color: #333;
            padding: 8px 15px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            background: none;
            font-size: 14px;
        }
        
        .nav-links a:hover {
            background: #f0f0f0;
        }
        
        .btn-logout {
            background: #e74c3c;
            color: white;
        }
        
        .btn-logout:hover {
            background: #c0392b;
        }
        
        .user-welcome {
            color: white;
            font-weight: bold;
            background: #667eea;
            padding: 8px 15px;
            border-radius: 5px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        h1 {
            color: white;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .projects-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .project-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
        }
        
        .project-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.2);
        }
        
        .project-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            min-height: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }
        
        .project-header h3 {
            font-size: 18px;
        }
        
        .project-body {
            padding: 20px;
        }
        
        .project-body p {
            color: #7f8c8d;
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.5;
        }
        
        .price {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .tech-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            margin-bottom: 15px;
        }
        
        .tech-tag {
            background: #ecf0f1;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
            color: #667eea;
        }
        
        .project-footer {
            padding: 15px 20px;
            border-top: 1px solid #ecf0f1;
        }
        
        .btn {
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            width: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-weight: bold;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        footer {
            background: #2c3e50;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 40px;
        }
        
        @media (max-width: 768px) {
            .projects-grid {
                grid-template-columns: 1fr;
            }
            
            nav {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav-links {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <header>
        <nav>
            <a href="index.php" class="logo">🚀 SourceHub</a>
            <div class="nav-links">
                <a href="index.php">Home</a>
                <a href="projects.php">Projects</a>
                <?php if ($user_id): ?>
                    <a href="dashboard.php">Dashboard</a>
                    <?php if ($is_admin): ?>
                        <a href="admin.php" style="color: #f39c12; font-weight: bold;">🔒 Admin</a>
                    <?php endif; ?>
                    <span class="user-welcome">👤 <?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <button class="btn-logout" onclick="window.location.href='logout.php'">Logout</button>
                <?php else: ?>
                    <a href="login.php">Login</a>
                    <a href="register.php">Register</a>
                <?php endif; ?>
            </div>
        </nav>
    </header>

    <div class="container">
        <h1>All Projects</h1>
        
        <div class="projects-grid">
            <?php
            $projects = $conn->query("SELECT * FROM projects ORDER BY created_at DESC");
            while ($project = $projects->fetch_assoc()):
            ?>
            <div class="project-card">
                <div class="project-header">
                    <h3><?php echo htmlspecialchars($project['title']); ?></h3>
                </div>
                <div class="project-body">
                    <p><?php echo htmlspecialchars($project['short_description']); ?></p>
                    <div class="price">$<?php echo number_format($project['price'], 2); ?></div>
                    <div class="tech-tags">
                        <?php 
                        $techs = array_slice(explode(',', $project['tech_stack']), 0, 3);
                        foreach ($techs as $tech):
                        ?>
                        <span class="tech-tag"><?php echo htmlspecialchars(trim($tech)); ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="project-footer">
                    <a href="project.php?id=<?php echo $project['id']; ?>" class="btn">View Details</a>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
    </div>

    <footer>
        <p>&copy; 2024 SourceHub - Digital Projects Marketplace. All rights reserved.</p>
    </footer>
</body>
</html>
